#include <iostream>
#include <unordered_set>
#include <string>

using namespace std;

bool validateMessage(const string &alphabet, const string &message) {
    // Converte o alfabeto em um conjunto de caracteres
    unordered_set<char> alphabetSet(alphabet.begin(), alphabet.end());

    // Verifica se todos os caracteres da mensagem estão no conjunto
    for (char c : message) {
        if (alphabetSet.find(c) == alphabetSet.end()) {
            return false;
        }
    }
    return true;
}

int main() {
    while (true) {
        int k, n;

        // Entrada de k e n
        cout << "Digite k e n (0 0 para sair): ";
        cin >> k >> n;
        cin.ignore(); // Consumir o caractere de quebra de linha

        if (k == 0 && n == 0) {
            break;
        }

        // Entrada do alfabeto e mensagem
        string alphabet, message;
        cout << "Digite o alfabeto permitido: ";
        getline(cin, alphabet);
        cout << "Digite a mensagem a ser verificada: ";
        getline(cin, message);

        // Validação
        if (validateMessage(alphabet, message)) {
            cout << "Sim" << endl;
        } else {
            cout << "Não" << endl;
        }
    }

    return 0;
}
